/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.MergeInput;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;

public abstract class BaseMergeParameters<T extends MergeInput>
extends AbstractPdfOutputParameters
implements SingleOutputTaskParameters {
    @NotEmpty
    @Valid
    private List<T> inputList = new ArrayList<T>();
    @Valid
    @NotNull
    private SingleTaskOutput output;

    @Override
    public SingleTaskOutput getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(SingleTaskOutput output) {
        this.output = output;
    }

    public List<T> getInputList() {
        return Collections.unmodifiableList(this.inputList);
    }

    public void setInputList(List<T> inputList) {
        this.inputList = inputList;
    }

    public List<PdfMergeInput> getPdfInputList() {
        return this.inputList.stream().map(input -> (PdfMergeInput)input).collect(Collectors.toUnmodifiableList());
    }

    public void addInput(T input) {
        this.inputList.add(input);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.inputList).append((Object)this.output).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseMergeParameters)) {
            return false;
        }
        BaseMergeParameters params = (BaseMergeParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.inputList, params.inputList).append((Object)this.output, (Object)params.getOutput()).isEquals();
    }
}

