/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.image;

import java.util.EnumSet;
import java.util.Set;

public enum ImageType {
    PNG("image/png", "png", false),
    JPEG("image/jpeg", "jpg", false),
    GIF("image/gif", "gif", true),
    TIFF("image/tiff", "tif", true);

    private final String mimeType;
    private final String extension;
    private final boolean supportMultiImage;

    private ImageType(String mimeType, String extension, boolean supportMultiImage) {
        this.mimeType = mimeType;
        this.extension = extension;
        this.supportMultiImage = supportMultiImage;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isSupportMultiImage() {
        return this.supportMultiImage;
    }

    public String getExtension() {
        return this.extension;
    }

    public static Set<ImageType> valuesSupportingMultipleImage() {
        EnumSet<ImageType> retSet = EnumSet.noneOf(ImageType.class);
        for (ImageType current : ImageType.values()) {
            if (!current.isSupportMultiImage()) continue;
            retSet.add(current);
        }
        return retSet;
    }
}

