/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.model.PrefixTransformationContext;
import org.sejda.core.support.prefix.processor.PrefixProcessor;

class BaseBookmarkPrefixProcessor
implements PrefixProcessor {
    private final Pattern pattern;
    private final String invalidCharsRegexp;

    BaseBookmarkPrefixProcessor(String prefixNameRegex, String invalidCharsRegexp) {
        this.pattern = Pattern.compile(prefixNameRegex);
        this.invalidCharsRegexp = invalidCharsRegexp;
    }

    @Override
    public void accept(PrefixTransformationContext context) {
        Matcher matcher = this.pattern.matcher(context.currentPrefix());
        if (matcher.find()) {
            Optional.ofNullable(context.request()).map(NameGenerationRequest::getBookmark).map(b -> b.replaceAll(this.invalidCharsRegexp, "")).map(Matcher::quoteReplacement).filter(StringUtils::isNotBlank).ifPresent(r -> {
                context.uniqueNames(true);
                context.currentPrefix(matcher.replaceAll((String)r));
            });
        }
    }
}

