/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.notification.context;

import java.util.List;
import org.sejda.commons.collection.ListValueMap;
import org.sejda.core.notification.context.EventListenerHoldingStrategy;
import org.sejda.core.support.util.ReflectionUtils;
import org.sejda.model.exception.NotificationContextException;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.AbstractNotificationEvent;

class SimpleEventListenerHoldingStrategy
implements EventListenerHoldingStrategy {
    private final ListValueMap<Class<? extends AbstractNotificationEvent>, EventListener<? extends AbstractNotificationEvent>> listeners = new ListValueMap();

    SimpleEventListenerHoldingStrategy() {
    }

    @Override
    public <T extends AbstractNotificationEvent> void add(EventListener<T> listener) {
        Class<T> eventClass = this.getListenerEventClass(listener);
        this.listeners.put(eventClass, listener);
    }

    @Override
    public <T extends AbstractNotificationEvent> void add(Class<T> eventClass, EventListener<T> listener) {
        this.listeners.put(eventClass, listener);
    }

    @Override
    public <T extends AbstractNotificationEvent> boolean remove(EventListener<T> listener) {
        Class<T> eventClass = this.getListenerEventClass(listener);
        return this.listeners.remove(eventClass, listener);
    }

    private <T extends AbstractNotificationEvent> Class<T> getListenerEventClass(EventListener<T> listener) {
        Class eventClass = ReflectionUtils.inferParameterClass(listener.getClass(), "onEvent");
        if (eventClass == null) {
            throw new NotificationContextException("Unable to infer the listened event class.");
        }
        return eventClass;
    }

    @Override
    public void clear() {
        this.listeners.clear();
    }

    @Override
    public List<EventListener<? extends AbstractNotificationEvent>> get(AbstractNotificationEvent event) {
        return this.listeners.get(event.getClass());
    }

    @Override
    public int size() {
        return this.listeners.size();
    }
}

