/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.FloatPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableFloatProperty
extends FloatPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin = null;
    private TransitionMediatorImpl mediator = null;

    public StyleableFloatProperty() {
    }

    public StyleableFloatProperty(float f) {
        super(f);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        float f;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        float f2 = f = number != null ? number.floatValue() : 0.0f;
        if (transitionDefinition2 == null) {
            this.set(f);
        } else if (this.mediator == null || this.mediator.newValue != f) {
            this.mediator = new TransitionMediatorImpl(this.get(), f);
            this.mediator.run(transitionDefinition2);
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel(true);
        }
    }

    public void set(float f) {
        super.set(f);
        if (this.mediator == null || this.mediator.cancel(false)) {
            this.origin = StyleOrigin.USER;
        }
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final float oldValue;
        private final float newValue;

        public TransitionMediatorImpl(float f, float f2) {
            this.oldValue = f;
            this.newValue = f2;
        }

        @Override
        public void onUpdate(double d) {
            StyleableFloatProperty.this.set(d < 1.0 ? this.oldValue + (this.newValue - this.oldValue) * (float)d : this.newValue);
        }

        @Override
        public void onStop() {
            if (StyleableFloatProperty.this.mediator == this) {
                StyleableFloatProperty.this.mediator = null;
            }
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableFloatProperty.this;
        }
    }
}

