/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.tool;

import java.util.Map;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.workspace.LoadWorkspaceResponse;
import org.pdfsam.model.ui.workspace.SaveWorkspaceRequest;
import org.pdfsam.ui.components.notification.AddNotificationRequest;
import org.pdfsam.ui.components.notification.NotificationType;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.RunButtonTriggerRequest;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.parameter.base.AbstractParameters;

public abstract class BaseToolPanel
extends BorderPane
implements ToolBound {
    private final Footer footer;
    private final String toolId;

    public BaseToolPanel(String toolId, Footer footer) {
        RequireUtils.requireNotBlank((String)toolId, (String)"Bound tool id cannot be blank");
        this.toolId = toolId;
        this.footer = footer;
    }

    protected final void initModuleSettingsPanel(VBox panel) {
        panel.getStyleClass().addAll((Object[])Style.DEAULT_CONTAINER.css());
        panel.getStyleClass().addAll((Object[])Style.MODULE_CONTAINER.css());
        panel.getChildren().add((Object)this.footer);
        this.footer.runButton().setOnAction(event -> {
            ErrorTracker errorTracker = new ErrorTracker();
            Builder<? extends AbstractParameters> builder = this.getBuilder(errorTracker.andThen(s -> StaticStudio.eventStudio().broadcast((Object)new AddNotificationRequest(NotificationType.ERROR, (String)s, I18nContext.i18n().tr("Invalid parameters")))));
            if (!errorTracker.errorOnBuild) {
                StaticStudio.eventStudio().broadcast((Object)new TaskExecutionRequest(this.toolBinding(), (AbstractParameters)builder.build()));
            }
        });
        this.setCenter((Node)panel);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public String toolBinding() {
        return this.toolId;
    }

    @EventListener
    public final void saveStateData(SaveWorkspaceRequest event) {
        this.onSaveWorkspace(event.getData(this.toolBinding()));
    }

    @EventListener
    public final void restoreState(LoadWorkspaceResponse event) {
        Platform.runLater(() -> this.onLoadWorkspace(event.getData(this.toolBinding())));
    }

    public abstract void onSaveWorkspace(Map<String, String> var1);

    public abstract void onLoadWorkspace(Map<String, String> var1);

    @EventListener
    public void onRunButtonAccelerator(RunButtonTriggerRequest request) {
        this.footer.runButton().fire();
    }

    protected abstract Builder<? extends AbstractParameters> getBuilder(Consumer<String> var1);

    private static class ErrorTracker
    implements Consumer<String> {
        boolean errorOnBuild = false;

        private ErrorTracker() {
        }

        @Override
        public void accept(String error) {
            this.errorOnBuild = true;
        }
    }
}

