/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.single;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.core.support.EncryptionUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.io.NativeOpenFileRequest;
import org.pdfsam.model.io.OpenType;
import org.pdfsam.model.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfDocumentDescriptorProvider;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.ChangedSelectedPdfVersionEvent;
import org.pdfsam.model.ui.SetDestinationRequest;
import org.pdfsam.model.ui.ShowLogMessagesRequest;
import org.pdfsam.model.ui.ShowPdfDescriptorRequest;
import org.pdfsam.model.ui.ShowStageRequest;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.ui.components.commons.ToggleChangeListener;
import org.pdfsam.ui.components.io.BrowsableFileField;
import org.pdfsam.ui.components.selection.LoadingStatusIndicatorUpdater;
import org.pdfsam.ui.components.selection.PasswordFieldPopup;
import org.pdfsam.ui.components.selection.single.SingleSelectionPaneToolbar;
import org.pdfsam.ui.components.support.FXValidationSupport;

public class SingleSelectionPane
extends VBox
implements ToolBound,
PdfDocumentDescriptorProvider,
RestorableView {
    private String ownerModule = "";
    private final BrowsableFileField field;
    private final Label details = new Label();
    private PdfDocumentDescriptor descriptor;
    private final PasswordFieldPopup passwordPopup;
    private final Label encryptionIndicator = new Label();
    private MenuItem removeSelected;
    private Consumer<PdfDocumentDescriptor> onLoaded = d -> {
        StaticStudio.eventStudio().broadcast((Object)SetDestinationRequest.requestFallbackDestination((File)d.getFile(), (String)this.toolBinding()), this.toolBinding());
        StaticStudio.eventStudio().broadcast((Object)new ChangedSelectedPdfVersionEvent(d.getVersion()), this.toolBinding());
    };
    private final Consumer<PdfDocumentDescriptor> detailsUpdate = d -> {
        PdfDescriptorLoadingStatus status = (PdfDescriptorLoadingStatus)d.loadingStatus().getValue();
        if (status == PdfDescriptorLoadingStatus.LOADED || status == PdfDescriptorLoadingStatus.LOADED_WITH_USER_PWD_DECRYPTION) {
            this.details.setText(I18nContext.i18n().tr("Pages: {0}, PDF Version: {1}", new String[]{Integer.toString((Integer)d.pages().getValue()), d.getVersionString()}));
        } else if (status == PdfDescriptorLoadingStatus.LOADING) {
            this.details.setText(I18nContext.i18n().tr("Loading..."));
        } else {
            this.details.setText("");
        }
    };
    private final Consumer<PdfDocumentDescriptor> encryptionIndicatorUpdate = new Consumer<PdfDocumentDescriptor>(){
        private final LoadingStatusIndicatorUpdater updater;
        {
            this.updater = new LoadingStatusIndicatorUpdater((Labeled)SingleSelectionPane.this.encryptionIndicator);
        }

        @Override
        public void accept(PdfDocumentDescriptor t) {
            this.updater.accept((PdfDescriptorLoadingStatus)t.loadingStatus().getValue());
        }
    };
    private final ChangeListener<PdfDescriptorLoadingStatus> onLoadingStatusChange = (o, oldVal, newVal) -> {
        if (this.descriptor != null && this.descriptor.hasReferences()) {
            this.encryptionIndicatorUpdate.andThen(this.detailsUpdate).andThen(d -> {
                PdfDescriptorLoadingStatus status = (PdfDescriptorLoadingStatus)d.loadingStatus().getValue();
                if (status == PdfDescriptorLoadingStatus.LOADED || status == PdfDescriptorLoadingStatus.LOADED_WITH_USER_PWD_DECRYPTION) {
                    this.onLoaded.accept((PdfDocumentDescriptor)d);
                }
            }).accept(this.descriptor);
        }
    };
    private final ToggleChangeListener<? super FXValidationSupport.ValidationState> onValidState = new ToggleChangeListener<FXValidationSupport.ValidationState>(){

        @Override
        public void onChanged(ObservableValue<? extends FXValidationSupport.ValidationState> observable, FXValidationSupport.ValidationState oldValue, FXValidationSupport.ValidationState newVal) {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                SingleSelectionPane.this.initializeFor(PdfDocumentDescriptor.newDescriptorNoPassword((File)new File(SingleSelectionPane.this.field.getTextField().getText())));
            } else {
                SingleSelectionPane.this.reset();
            }
        }
    };

    public SingleSelectionPane(String ownerModule) {
        this(ownerModule, true);
    }

    public SingleSelectionPane(String ownerModule, boolean addToolbar) {
        this.getStyleClass().add((Object)"single-selection-pane");
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.details.getStyleClass().add((Object)"-pdfsam-selection-details");
        if (addToolbar) {
            SingleSelectionPaneToolbar.SelectButton selectButton = new SingleSelectionPaneToolbar.SelectButton(this.toolBinding());
            this.field = new BrowsableFileField(FileType.PDF, OpenType.OPEN, selectButton);
            HBox.setHgrow((Node)this.field, (Priority)Priority.ALWAYS);
            this.getChildren().addAll((Object[])new Node[]{new SingleSelectionPaneToolbar(selectButton, this.toolBinding()), this.field, this.details});
        } else {
            this.field = new BrowsableFileField(FileType.PDF, OpenType.OPEN);
            HBox.setHgrow((Node)this.field, (Priority)Priority.ALWAYS);
            this.getChildren().addAll((Object[])new Node[]{this.field, this.details});
        }
        this.field.enforceValidation(true, false);
        this.field.getStyleClass().add((Object)"single-selection-top");
        this.field.getTextField().validProperty().addListener(this.onValidState);
        this.passwordPopup = new PasswordFieldPopup(this.ownerModule);
        this.initEncryptionIndicator();
        this.initContextMenu();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void initEncryptionIndicator() {
        this.encryptionIndicator.getStyleClass().addAll((Object[])new String[]{"encryption-status"});
        this.encryptionIndicator.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.descriptor.loadingStatus().getValue() == PdfDescriptorLoadingStatus.ENCRYPTED) {
                this.showPasswordFieldPopup();
            } else if (this.descriptor.loadingStatus().getValue() == PdfDescriptorLoadingStatus.WITH_ERRORS) {
                StaticStudio.eventStudio().broadcast((Object)new ShowLogMessagesRequest());
            }
        });
        HBox.setMargin((Node)this.encryptionIndicator, (Insets)new Insets(0.0, 0.0, 0.0, 2.0));
        this.field.setGraphic((Node)this.encryptionIndicator);
    }

    private void initializeFor(PdfDocumentDescriptor docDescriptor) {
        this.invalidateDescriptor();
        PdfLoadRequest loadEvent = new PdfLoadRequest(this.toolBinding());
        this.descriptor = docDescriptor;
        this.descriptor.loadingStatus().addListener((ChangeListener)new WeakChangeListener(this.onLoadingStatusChange));
        this.setContextMenuDisable(false);
        loadEvent.add(this.descriptor);
        StaticStudio.eventStudio().broadcast((Object)loadEvent);
    }

    private void reset() {
        this.invalidateDescriptor();
        this.setContextMenuDisable(true);
        this.encryptionIndicator.setText("");
        this.details.setText("");
    }

    private void disableRemoveMenuItemIfNeeded() {
        this.removeSelected.setDisable(StringUtils.isEmpty((CharSequence)this.field.getTextField().getText()));
    }

    private void setContextMenuDisable(boolean value) {
        this.field.getTextField().getContextMenu().getItems().forEach(i -> i.setDisable(value));
        this.disableRemoveMenuItemIfNeeded();
    }

    private void invalidateDescriptor() {
        if (Objects.nonNull(this.descriptor)) {
            this.descriptor.releaseAll();
        }
    }

    private void showPasswordFieldPopup() {
        Window owner;
        Scene scene = this.getScene();
        if (scene != null && (owner = scene.getWindow()) != null && owner.isShowing()) {
            Point2D nodeCoord = this.encryptionIndicator.localToScene(this.encryptionIndicator.getWidth() / 2.0, this.encryptionIndicator.getHeight() / 1.5);
            double anchorX = Math.round(owner.getX() + scene.getX() + nodeCoord.getX() + 2.0);
            double anchorY = Math.round(owner.getY() + scene.getY() + nodeCoord.getY() + 2.0);
            this.passwordPopup.showFor((Node)this, this.descriptor, anchorX, anchorY);
        }
    }

    public PdfDocumentDescriptor getPdfDocumentDescriptor() {
        return this.descriptor;
    }

    public BrowsableFileField getField() {
        return this.field;
    }

    public void saveStateTo(Map<String, String> data) {
        if (this.descriptor != null) {
            data.put(StringUtils.defaultString((String)this.getId()) + "input", this.descriptor.getFile().getAbsolutePath());
            if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SAVE_PWD_IN_WORKSPACE)) {
                data.put(StringUtils.defaultString((String)this.getId()) + "input.password.enc", EncryptionUtils.encrypt((String)this.descriptor.getPassword()));
            }
        }
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.getField().getTextField().setText("");
        Optional.ofNullable(data.get(StringUtils.defaultString((String)this.getId()) + "input")).ifPresent(f -> {
            this.onValidState.disabled(true);
            this.getField().getTextField().setText((String)f);
            this.onValidState.disabled(false);
            this.initializeFor(PdfDocumentDescriptor.newDescriptor((File)new File((String)f), (String)Optional.ofNullable((String)data.get(StringUtils.defaultString((String)this.getId()) + "input.password.enc")).map(EncryptionUtils::decrypt).orElseGet(() -> (String)data.get(StringUtils.defaultString((String)this.getId()) + "input.password"))));
        });
    }

    public void addOnLoaded(Consumer<PdfDocumentDescriptor> onDescriptorLoaded) {
        this.onLoaded = onDescriptorLoaded.andThen(this.onLoaded);
    }

    private void initContextMenu() {
        MenuItem infoItem = this.createMenuItem(I18nContext.i18n().tr("Document properties"), (Ikon)UniconsLine.INFO_CIRCLE);
        infoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        infoItem.setOnAction(e -> Platform.runLater(() -> {
            StaticStudio.eventStudio().broadcast((Object)ShowStageRequest.INSTANCE, "InfoStage");
            StaticStudio.eventStudio().broadcast((Object)new ShowPdfDescriptorRequest(this.descriptor));
        }));
        this.removeSelected = this.createMenuItem(I18nContext.i18n().tr("Remove"), (Ikon)UniconsLine.MINUS);
        this.removeSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(this.toolBinding(), false, false), this.toolBinding()));
        MenuItem setDestinationItem = this.createMenuItem(I18nContext.i18n().tr("Set destination"), (Ikon)UniconsLine.CROSSHAIR);
        setDestinationItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        setDestinationItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)SetDestinationRequest.requestDestination((File)this.descriptor.getFile(), (String)this.toolBinding()), this.toolBinding()));
        MenuItem openFileItem = this.createMenuItem(I18nContext.i18n().tr("Open"), (Ikon)UniconsLine.FILE_ALT);
        openFileItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new NativeOpenFileRequest(this.descriptor.getFile())));
        MenuItem openFolderItem = this.createMenuItem(I18nContext.i18n().tr("Open Folder"), (Ikon)UniconsLine.FOLDER);
        openFolderItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new NativeOpenFileRequest(this.descriptor.getFile().getParentFile())));
        this.field.getTextField().setContextMenu(new ContextMenu(new MenuItem[]{setDestinationItem, new SeparatorMenuItem(), this.removeSelected, new SeparatorMenuItem(), infoItem, openFileItem, openFolderItem}));
    }

    @EventListener
    public void onClearSelected(ClearToolRequest event) {
        this.field.getTextField().clear();
        this.disableRemoveMenuItemIfNeeded();
    }

    @EventListener
    public void onLoadDocumentsRequest(PdfLoadRequest loadEvent) {
        loadEvent.getDocuments().stream().findFirst().map(PdfDocumentDescriptor::getFile).ifPresent(this.field::setTextFromFile);
    }

    private MenuItem createMenuItem(String text, Ikon icon) {
        MenuItem item = new MenuItem(text);
        item.setGraphic((Node)FontIcon.of((Ikon)icon));
        item.setDisable(true);
        return item;
    }

    @EventStation
    public String toolBinding() {
        return this.ownerModule;
    }

    public void setPromptText(String text) {
        this.field.getTextField().setPromptText(text);
    }
}

