/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.io.Choosers;
import org.pdfsam.core.io.FileChooserWithWorkingDirectory;
import org.pdfsam.eventstudio.DefaultEventStudio;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfFilesListLoadRequest;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.ui.components.selection.RemoveSelectedEvent;
import org.pdfsam.ui.components.selection.ToolbarButton;
import org.pdfsam.ui.components.selection.multiple.SelectionChangedEvent;
import org.pdfsam.ui.components.selection.multiple.move.MoveSelectedRequest;
import org.pdfsam.ui.components.selection.multiple.move.MoveType;
import org.pdfsam.ui.components.support.Style;

class SelectionTableToolbar
extends ToolBar
implements ToolBound {
    private String toolBinding = "";

    public SelectionTableToolbar(String toolBinding, boolean canMove) {
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.getItems().addAll((Object[])new Node[]{new AddButton(toolBinding), new ClearButton(toolBinding), new RemoveButton(toolBinding)});
        if (canMove) {
            this.getItems().addAll((Object[])new Node[]{new MoveUpButton(toolBinding), new MoveDownButton(toolBinding)});
        }
        this.getStyleClass().add((Object)"selection-tool-bar");
    }

    public String toolBinding() {
        return this.toolBinding;
    }

    static class AddButton
    extends SplitMenuButton
    implements ToolBound {
        private String ownerModule = "";

        public AddButton(String ownerModule) {
            this.ownerModule = StringUtils.defaultString((String)ownerModule);
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "toolbar-splitbutton"});
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Add documents to the table")));
            this.setText(I18nContext.i18n().tr("_Add"));
            this.setOnAction(this::loadDocuments);
            MenuItem fromList = new MenuItem();
            fromList.setText(I18nContext.i18n().tr("PDF list from _text/csv file"));
            fromList.setOnAction(this::loadList);
            this.getItems().add((Object)fromList);
        }

        public void loadDocuments(ActionEvent event) {
            FileChooserWithWorkingDirectory fileChooser = Choosers.fileChooser((String)I18nContext.i18n().tr("Select pdf documents to load"), (FileType[])new FileType[]{FileType.PDF});
            List chosenFiles = fileChooser.showOpenMultipleDialog(this.getScene().getWindow());
            if (chosenFiles != null && !chosenFiles.isEmpty()) {
                PdfLoadRequest loadEvent = new PdfLoadRequest(this.toolBinding());
                chosenFiles.stream().map(Path::toFile).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequest)loadEvent).add(arg_0));
                StaticStudio.eventStudio().broadcast((Object)loadEvent, this.toolBinding());
            }
        }

        public void loadList(ActionEvent event) {
            FileChooserWithWorkingDirectory fileChooser = Choosers.fileChooser((String)I18nContext.i18n().tr("Select a text or CSV file to load"), (FileType[])new FileType[]{FileType.CSV, FileType.TXT});
            Optional.ofNullable(fileChooser.showOpenSingleDialog(this.getScene().getWindow())).map(p -> new PdfFilesListLoadRequest(this.toolBinding(), p)).ifPresent(arg_0 -> ((DefaultEventStudio)StaticStudio.eventStudio()).broadcast(arg_0));
        }

        @EventStation
        public String toolBinding() {
            return this.ownerModule;
        }
    }

    static class ClearButton
    extends SplitMenuButton
    implements ToolBound {
        private String ownerModule = "";

        public ClearButton(String ownerModule) {
            this.setId("clear-button");
            this.ownerModule = StringUtils.defaultString((String)ownerModule);
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "toolbar-splitbutton"});
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Removes every document")));
            this.setText(I18nContext.i18n().tr("_Clear"));
            this.setOnAction(this::clear);
            MenuItem clearAllSettings = new MenuItem();
            clearAllSettings.setText(I18nContext.i18n().tr("C_lear all settings"));
            clearAllSettings.setOnAction(this::clearAll);
            this.getItems().add((Object)clearAllSettings);
        }

        public void clear(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(this.toolBinding(), false, true));
        }

        public void clearAll(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(this.toolBinding(), true, true));
        }

        @EventStation
        public String toolBinding() {
            return this.ownerModule;
        }
    }

    static class RemoveButton
    extends ToolbarButton {
        public RemoveButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Removes selected documents")));
            this.setText(I18nContext.i18n().tr("_Remove"));
            this.setOnAction(this::removeSelected);
            this.setDisable(true);
            StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        }

        public void removeSelected(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new RemoveSelectedEvent(), this.toolBinding());
        }

        @EventListener
        public void disableIfNoSelection(SelectionChangedEvent event) {
            this.setDisable(event.isClearSelection());
        }
    }

    static class MoveUpButton
    extends BaseMoveSelectedButton {
        public MoveUpButton(String ownerModule) {
            super(ownerModule, MoveType.UP);
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Moves up selected documents")));
            this.setText(I18nContext.i18n().tr("Move _Up"));
        }
    }

    static class MoveDownButton
    extends BaseMoveSelectedButton {
        public MoveDownButton(String ownerModule) {
            super(ownerModule, MoveType.DOWN);
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Moves down selected documents")));
            this.setText(I18nContext.i18n().tr("Move _Down"));
        }
    }

    private static class BaseMoveSelectedButton
    extends ToolbarButton {
        private final MoveType type;

        public BaseMoveSelectedButton(String ownerModule, MoveType type) {
            super(ownerModule);
            this.type = type;
            this.setDisable(true);
            this.setOnAction(this::moveOnClick);
            StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        }

        public void moveOnClick(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new MoveSelectedRequest(this.type), this.toolBinding());
        }

        @EventListener
        public void disableIfCannotMoveDown(SelectionChangedEvent event) {
            this.setDisable(!event.canMove(this.type));
        }
    }
}

