/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.util.Set;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.ConversionUtils;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.pdf.page.PageRange;

public final class SelectionTableRowData {
    private final PdfDocumentDescriptor descriptor;
    public final SimpleStringProperty pageSelection = new SimpleStringProperty("");
    public final SimpleStringProperty pace = new SimpleStringProperty("1");
    public final SimpleBooleanProperty reverse = new SimpleBooleanProperty(false);
    public final SimpleIntegerProperty selectedPages = new SimpleIntegerProperty(0);

    public SelectionTableRowData(PdfDocumentDescriptor descriptor) {
        this.descriptor = descriptor;
        this.pageSelection.addListener(v -> this.selectedPages.set(this.calculateSelectedPages()));
        descriptor.pages().addListener(v -> this.selectedPages.set(this.calculateSelectedPages()));
    }

    public SelectionTableRowData duplicate() {
        this.descriptor.retain();
        SelectionTableRowData dupe = new SelectionTableRowData(this.descriptor);
        dupe.pageSelection.set(this.pageSelection.get());
        dupe.reverse.set(this.reverse.get());
        dupe.pace.set(this.pace.get());
        dupe.selectedPages.set(this.selectedPages.get());
        return dupe;
    }

    private int calculateSelectedPages() {
        if (StringUtils.isBlank((CharSequence)this.pageSelection.get())) {
            return (Integer)this.descriptor.pages().getValue();
        }
        if ("0".equals(this.pageSelection.get())) {
            return 0;
        }
        try {
            return this.toPageRangeSet().stream().map(range -> Math.min((Integer)this.descriptor.pages().getValue(), range.getEnd()) - range.getStart() + 1).reduce(0, Integer::sum);
        }
        catch (ConversionException conversionException) {
            return 0;
        }
    }

    public PdfDocumentDescriptor descriptor() {
        return this.descriptor;
    }

    public void invalidate() {
        this.descriptor.release();
    }

    public Set<PageRange> toPageRangeSet() throws ConversionException {
        return ConversionUtils.toPageRangeSet((String)this.pageSelection.get());
    }
}

