/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.core.support.EncryptionUtils;
import org.pdfsam.core.support.io.ObjectCollectionWriter;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.NativeOpenFileRequest;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.SetDestinationRequest;
import org.pdfsam.model.ui.ShowPdfDescriptorRequest;
import org.pdfsam.model.ui.ShowStageRequest;
import org.pdfsam.model.ui.dnd.FilesDroppedEvent;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.ui.components.selection.PasswordFieldPopup;
import org.pdfsam.ui.components.selection.RemoveSelectedEvent;
import org.pdfsam.ui.components.selection.SetPageRangesRequest;
import org.pdfsam.ui.components.selection.ShowPasswordFieldPopupRequest;
import org.pdfsam.ui.components.selection.multiple.DuplicateSelectedEvent;
import org.pdfsam.ui.components.selection.multiple.DuplicateType;
import org.pdfsam.ui.components.selection.multiple.IndexColumn;
import org.pdfsam.ui.components.selection.multiple.PageRangesColumn;
import org.pdfsam.ui.components.selection.multiple.SelectionChangedEvent;
import org.pdfsam.ui.components.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.components.selection.multiple.TableColumnProvider;
import org.pdfsam.ui.components.selection.multiple.move.MoveSelectedRequest;
import org.pdfsam.ui.components.selection.multiple.move.MoveType;
import org.pdfsam.ui.components.selection.multiple.move.SelectionAndFocus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionTable
extends TableView<SelectionTableRowData>
implements ToolBound,
RestorableView {
    private static final Logger LOG = LoggerFactory.getLogger(SelectionTable.class);
    private static final PseudoClass DRAG_HOVERED_TOP_ROW_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"drag-hovered-row-top");
    private static final PseudoClass DRAG_HOVERED_BOTTOM_ROW_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"drag-hovered-row-bottom");
    private static final DataFormat DND_TABLE_SELECTION_MIME_TYPE = new DataFormat(new String[]{"application/x-java-table-selection-list"});
    private final String toolBinding;
    private final Label placeHolder = new Label(I18nContext.i18n().tr("Drag and drop PDF files here"));
    private final PasswordFieldPopup passwordPopup;
    private final IntegerProperty hoverIndex = new SimpleIntegerProperty(-1);
    private Consumer<SelectionChangedEvent> selectionChangedConsumer;
    private final Timeline scrollTimeline = new Timeline();
    private double scrollDirection = 0.0;

    public SelectionTable(String toolBinding, boolean canDuplicateItems, boolean canMove, TableColumnProvider<?> ... columns) {
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.getColumns().add((Object)new IndexColumn());
        Arrays.stream(columns).forEach(c -> this.getColumns().add(c.getTableColumn()));
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.getStyleClass().add((Object)"selection-table");
        this.initDragAndDrop(canMove);
        this.getSelectionModel().getSelectedIndices().addListener(c -> {
            ObservableList selected = c.getList();
            if (selected.isEmpty()) {
                StaticStudio.eventStudio().broadcast((Object)SelectionChangedEvent.clearSelectionEvent(), toolBinding);
                LOG.trace("Selection cleared for {}", (Object)toolBinding);
            } else {
                SelectionChangedEvent newSelectionEvent = SelectionChangedEvent.select((Collection<? extends Integer>)selected).ofTotalRows(this.getItems().size());
                StaticStudio.eventStudio().broadcast((Object)newSelectionEvent, toolBinding);
                LOG.trace("{} for {}", (Object)newSelectionEvent, (Object)toolBinding);
            }
        });
        this.placeHolder.getStyleClass().add((Object)"drag-drop-placeholder");
        this.placeHolder.setDisable(true);
        this.setPlaceholder((Node)this.placeHolder);
        this.passwordPopup = new PasswordFieldPopup(this.toolBinding);
        ContextMenu contextMenu = new ContextMenu();
        this.initTopSectionContextMenu(contextMenu, Arrays.stream(columns).anyMatch(PageRangesColumn.class::isInstance));
        this.initItemsSectionContextMenu(contextMenu, canDuplicateItems, canMove);
        this.initBottomSectionContextMenu(contextMenu);
        this.setContextMenu(contextMenu);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        StaticStudio.eventStudio().add(SelectionChangedEvent.class, e -> this.selectionChangedConsumer.accept((SelectionChangedEvent)e), toolBinding);
    }

    private void initTopSectionContextMenu(ContextMenu contextMenu, boolean hasRanges) {
        MenuItem setDestinationItem = this.createMenuItem(I18nContext.i18n().tr("Set destination"), (Ikon)UniconsLine.CROSSHAIR);
        setDestinationItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)SetDestinationRequest.requestDestination((File)((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile(), (String)this.toolBinding()), this.toolBinding()));
        setDestinationItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        this.selectionChangedConsumer = e -> setDestinationItem.setDisable(!e.isSingleSelection());
        contextMenu.getItems().add((Object)setDestinationItem);
        if (hasRanges) {
            MenuItem setPageRangesItem = this.createMenuItem(I18nContext.i18n().tr("Set as range for all"), (Ikon)UniconsLine.RIGHT_INDENT_ALT);
            setPageRangesItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new SetPageRangesRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).pageSelection.get()), this.toolBinding()));
            setPageRangesItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> setPageRangesItem.setDisable(!e.isSingleSelection()));
            contextMenu.getItems().add((Object)setPageRangesItem);
        }
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
    }

    private void initItemsSectionContextMenu(ContextMenu contextMenu, boolean canDuplicate, boolean canMove) {
        MenuItem removeSelected = this.createMenuItem(I18nContext.i18n().tr("Remove"), (Ikon)UniconsLine.MINUS);
        removeSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new RemoveSelectedEvent(), this.toolBinding()));
        removeSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
        contextMenu.getItems().add((Object)removeSelected);
        this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> removeSelected.setDisable(e.isClearSelection()));
        if (canMove) {
            MenuItem moveTopSelected = this.createMenuItem(I18nContext.i18n().tr("Move to Top"), (Ikon)UniconsLine.ANGLE_DOUBLE_UP);
            moveTopSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedRequest(MoveType.TOP), this.toolBinding()));
            MenuItem moveUpSelected = this.createMenuItem(I18nContext.i18n().tr("Move Up"), (Ikon)UniconsLine.ANGLE_UP);
            moveUpSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedRequest(MoveType.UP), this.toolBinding()));
            MenuItem moveDownSelected = this.createMenuItem(I18nContext.i18n().tr("Move Down"), (Ikon)UniconsLine.ANGLE_DOWN);
            moveDownSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedRequest(MoveType.DOWN), this.toolBinding()));
            MenuItem moveBottomSelected = this.createMenuItem(I18nContext.i18n().tr("Move to Bottom"), (Ikon)UniconsLine.ANGLE_DOUBLE_DOWN);
            moveBottomSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedRequest(MoveType.BOTTOM), this.toolBinding()));
            contextMenu.getItems().addAll((Object[])new MenuItem[]{moveTopSelected, moveUpSelected, moveDownSelected, moveBottomSelected});
            moveBottomSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveDownSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveUpSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveTopSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
                moveTopSelected.setDisable(!e.canMove(MoveType.TOP));
                moveUpSelected.setDisable(!e.canMove(MoveType.UP));
                moveDownSelected.setDisable(!e.canMove(MoveType.DOWN));
                moveBottomSelected.setDisable(!e.canMove(MoveType.BOTTOM));
            });
        }
        if (canDuplicate) {
            Menu duplicateItem = new Menu(I18nContext.i18n().tr("Duplicate"));
            duplicateItem.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.COPY));
            duplicateItem.setDisable(true);
            MenuItem duplicateTop = this.createMenuItem(I18nContext.i18n().tr("Duplicate at Top"), null);
            duplicateTop.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new DuplicateSelectedEvent(DuplicateType.TOP), this.toolBinding()));
            duplicateTop.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            MenuItem duplicateUp = this.createMenuItem(I18nContext.i18n().tr("Duplicate Up"), null);
            duplicateUp.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new DuplicateSelectedEvent(DuplicateType.UP), this.toolBinding()));
            duplicateUp.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            MenuItem duplicateDown = this.createMenuItem(I18nContext.i18n().tr("Duplicate Down"), null);
            duplicateDown.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new DuplicateSelectedEvent(DuplicateType.DOWN), this.toolBinding()));
            duplicateDown.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            MenuItem duplicateBottom = this.createMenuItem(I18nContext.i18n().tr("Duplicate at Bottom"), null);
            duplicateBottom.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new DuplicateSelectedEvent(DuplicateType.BOTTOM), this.toolBinding()));
            duplicateBottom.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            duplicateItem.getItems().addAll((Object[])new MenuItem[]{duplicateTop, duplicateUp, duplicateDown, duplicateBottom});
            contextMenu.getItems().add((Object)duplicateItem);
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
                duplicateItem.setDisable(e.isClearSelection());
                duplicateTop.setDisable(e.isClearSelection());
                duplicateBottom.setDisable(e.isClearSelection());
                duplicateUp.setDisable(e.isClearSelection());
                duplicateDown.setDisable(e.isClearSelection());
            });
        }
    }

    private void initBottomSectionContextMenu(ContextMenu contextMenu) {
        MenuItem copyItem = this.createMenuItem(I18nContext.i18n().tr("Copy to clipboard"), (Ikon)UniconsLine.COPY_ALT);
        copyItem.setOnAction(e -> this.copySelectedToClipboard());
        MenuItem infoItem = this.createMenuItem(I18nContext.i18n().tr("Document properties"), (Ikon)UniconsLine.INFO_CIRCLE);
        infoItem.setOnAction(e -> Platform.runLater(() -> {
            StaticStudio.eventStudio().broadcast((Object)ShowStageRequest.INSTANCE, "InfoStage");
            StaticStudio.eventStudio().broadcast((Object)new ShowPdfDescriptorRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor()));
        }));
        MenuItem openFileItem = this.createMenuItem(I18nContext.i18n().tr("Open"), (Ikon)UniconsLine.FILE_ALT);
        openFileItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new NativeOpenFileRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile())));
        MenuItem openFolderItem = this.createMenuItem(I18nContext.i18n().tr("Open Folder"), (Ikon)UniconsLine.FOLDER);
        openFolderItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new NativeOpenFileRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile().getParentFile())));
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        infoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        openFileItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        openFolderItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), copyItem, infoItem, openFileItem, openFolderItem});
        this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
            copyItem.setDisable(e.isClearSelection());
            infoItem.setDisable(!e.isSingleSelection());
            openFileItem.setDisable(!e.isSingleSelection());
            openFolderItem.setDisable(!e.isSingleSelection());
        });
    }

    private MenuItem createMenuItem(String text, Ikon icon) {
        MenuItem item = new MenuItem(text);
        if (Objects.nonNull(icon)) {
            item.setGraphic((Node)FontIcon.of((Ikon)icon));
        }
        item.setDisable(true);
        return item;
    }

    private void initDragAndDrop(boolean canMove) {
        this.scrollTimeline.setCycleCount(-1);
        this.scrollTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)20.0), "Scroll", event -> this.dragScroll(), new KeyValue[0]));
        this.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_EXITED, this::stopAutoScrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_DROPPED, this::stopAutoScrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_DONE, this::stopAutoScrollIfNeeded);
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragEntered(e -> this.dragConsume((DragEvent)e, this.onDragEnteredConsumer()));
        this.setOnDragExited(this::onDragExited);
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
        if (canMove) {
            this.setRowFactory(tv -> {
                TableRow row = new TableRow();
                row.setOnDragDetected(e -> {
                    ArrayList selection = new ArrayList(this.getSelectionModel().getSelectedIndices());
                    if (!row.isEmpty() && !selection.isEmpty()) {
                        Dragboard db = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        db.setDragView((Image)row.snapshot(null, null));
                        ClipboardContent cc = new ClipboardContent();
                        cc.put((Object)DND_TABLE_SELECTION_MIME_TYPE, selection);
                        db.setContent((Map)cc);
                        e.consume();
                    }
                });
                row.setOnDragOver(e -> {
                    int rowIndex = row.getIndex();
                    int affectedRowIndex = e.getY() > row.getHeight() / 2.0 ? rowIndex + 1 : rowIndex;
                    this.hoverIndex.set(affectedRowIndex);
                    if (!row.isEmpty()) {
                        if (affectedRowIndex > rowIndex) {
                            SelectionTable.activateHoverBottomPsuedoClass(row);
                        } else {
                            SelectionTable.activateHoverTopPseudoClass(row);
                        }
                    } else {
                        SelectionTable.clearHoverPseudoClasses(row);
                    }
                    if (e.getGestureSource() != row && e.getDragboard().hasContent(DND_TABLE_SELECTION_MIME_TYPE) && !((List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE)).contains(rowIndex)) {
                        e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                        e.consume();
                    }
                });
                row.setOnDragEntered(e -> {
                    if (!row.isEmpty() && e.getDragboard().hasContent(DND_TABLE_SELECTION_MIME_TYPE) && !((List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE)).contains(row.getIndex())) {
                        row.setOpacity(0.6);
                    }
                });
                row.setOnDragExited(e -> {
                    SelectionTable.clearHoverPseudoClasses(row);
                    if (!row.isEmpty() && e.getDragboard().hasContent(DND_TABLE_SELECTION_MIME_TYPE) && !((List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE)).contains(row.getIndex())) {
                        row.setOpacity(1.0);
                    }
                });
                row.setOnDragDropped(e -> {
                    SelectionTable.clearHoverPseudoClasses(row);
                    Dragboard db = e.getDragboard();
                    if (db.hasContent(DND_TABLE_SELECTION_MIME_TYPE)) {
                        Optional<SelectionTableRowData> focus = Optional.ofNullable((SelectionTableRowData)this.getFocusModel().getFocusedItem());
                        Optional<SelectionTableRowData> toDrop = Optional.of(row).filter(r -> !r.isEmpty()).map(IndexedCell::getIndex).map(arg_0 -> this.getItems().get(arg_0));
                        List dragged = (List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE);
                        List<SelectionTableRowData> toMove = dragged.stream().map(arg_0 -> this.getItems().get(arg_0)).filter(Objects::nonNull).toList();
                        this.getItems().removeAll(toMove);
                        int dropIndex = this.getItems().size();
                        if (toDrop.isPresent()) {
                            int toDropNewIndex = toDrop.map(arg_0 -> this.getItems().indexOf(arg_0)).get();
                            dropIndex = toDropNewIndex == row.getIndex() ? toDropNewIndex : toDropNewIndex + 1;
                        }
                        this.getSortOrder().clear();
                        this.getItems().addAll(dropIndex, toMove);
                        e.setDropCompleted(true);
                        this.getSelectionModel().clearSelection();
                        this.getSelectionModel().selectRange(dropIndex, dropIndex + toMove.size());
                        focus.map(arg_0 -> this.getItems().indexOf(arg_0)).ifPresent(arg_0 -> ((TableView.TableViewFocusModel)this.getFocusModel()).focus(arg_0));
                        e.consume();
                    }
                });
                return row;
            });
        }
    }

    private static <T> void activateHoverTopPseudoClass(TableRow<T> row) {
        row.pseudoClassStateChanged(DRAG_HOVERED_TOP_ROW_PSEUDO_CLASS, true);
        row.pseudoClassStateChanged(DRAG_HOVERED_BOTTOM_ROW_PSEUDO_CLASS, false);
    }

    private static <T> void activateHoverBottomPsuedoClass(TableRow<T> row) {
        row.pseudoClassStateChanged(DRAG_HOVERED_TOP_ROW_PSEUDO_CLASS, false);
        row.pseudoClassStateChanged(DRAG_HOVERED_BOTTOM_ROW_PSEUDO_CLASS, true);
    }

    private static <T> void clearHoverPseudoClasses(TableRow<T> row) {
        row.pseudoClassStateChanged(DRAG_HOVERED_TOP_ROW_PSEUDO_CLASS, false);
        row.pseudoClassStateChanged(DRAG_HOVERED_BOTTOM_ROW_PSEUDO_CLASS, false);
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragEnteredConsumer() {
        return e -> this.placeHolder.setDisable(false);
    }

    private void onDragExited(DragEvent e) {
        this.placeHolder.setDisable(true);
        e.consume();
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            StaticStudio.eventStudio().broadcast((Object)new FilesDroppedEvent(this.toolBinding, true, e.getDragboard().getFiles()));
            e.setDropCompleted(true);
        };
    }

    @EventStation
    public String toolBinding() {
        return this.toolBinding;
    }

    @EventListener(priority=-2147483648)
    public void onLoadDocumentsRequest(PdfLoadRequest loadEvent) {
        Optional<SelectionTableRowData> focus = Optional.ofNullable((SelectionTableRowData)this.getFocusModel().getFocusedItem());
        List<SelectionTableRowData> toDrop = loadEvent.getDocuments().stream().map(SelectionTableRowData::new).toList();
        int hoverIndexValue = this.hoverIndex.get();
        int itemsCount = this.getItems().size();
        int dropIndex = hoverIndexValue < 0 || hoverIndexValue > itemsCount ? itemsCount : hoverIndexValue;
        this.getSortOrder().clear();
        this.getItems().addAll(dropIndex, toDrop);
        focus.map(arg_0 -> this.getItems().indexOf(arg_0)).ifPresent(arg_0 -> ((TableView.TableViewFocusModel)this.getFocusModel()).focus(arg_0));
        this.sort();
        loadEvent.getDocuments().stream().findFirst().ifPresent(f -> StaticStudio.eventStudio().broadcast((Object)SetDestinationRequest.requestFallbackDestination((File)f.getFile(), (String)this.toolBinding()), this.toolBinding()));
        StaticStudio.eventStudio().broadcast((Object)loadEvent);
    }

    @EventListener
    public void onDuplicate(DuplicateSelectedEvent event) {
        LOG.trace("Duplicating selected items");
        switch (event.type()) {
            case TOP: {
                this.getSelectionModel().getSelectedItems().stream().map(SelectionTableRowData::duplicate).toList().reversed().forEach(arg_0 -> this.getItems().addFirst(arg_0));
                break;
            }
            case BOTTOM: {
                this.getSelectionModel().getSelectedItems().forEach(i -> this.getItems().addLast((Object)i.duplicate()));
                break;
            }
            case UP: {
                Integer index = (Integer)this.getSelectionModel().getSelectedIndices().stream().min(Integer::compareTo).get();
                this.getSelectionModel().getSelectedItems().stream().map(SelectionTableRowData::duplicate).toList().reversed().forEach(e -> this.getItems().add(index.intValue(), e));
                break;
            }
            case DOWN: {
                int index = (Integer)this.getSelectionModel().getSelectedIndices().stream().max(Integer::compareTo).get() + 1;
                this.getSelectionModel().getSelectedItems().stream().map(SelectionTableRowData::duplicate).toList().reversed().forEach(e -> this.getItems().add(index, e));
            }
        }
        this.sort();
    }

    @EventListener
    public void onClear(ClearToolRequest event) {
        this.getItems().forEach(d -> d.descriptor().releaseAll());
        this.getSelectionModel().clearSelection();
        this.getItems().clear();
    }

    @EventListener
    public void onRemoveSelected(RemoveSelectedEvent event) {
        TreeSet<Integer> indices = new TreeSet<Integer>(Collections.reverseOrder());
        indices.addAll((Collection<Integer>)this.getSelectionModel().getSelectedIndices());
        LOG.trace("Removing {} items", (Object)indices.size());
        indices.forEach(i -> ((SelectionTableRowData)this.getItems().remove(i.intValue())).invalidate());
        this.requestFocus();
    }

    @EventListener
    public void onMoveSelected(MoveSelectedRequest event) {
        this.getSortOrder().clear();
        ObservableList selectedIndices = this.getSelectionModel().getSelectedIndices();
        Integer[] selected = (Integer[])selectedIndices.toArray((Object[])new Integer[0]);
        int focus = this.getFocusModel().getFocusedIndex();
        this.getSelectionModel().clearSelection();
        SelectionAndFocus newSelection = event.type().move(selected, this.getItems(), focus);
        if (!SelectionAndFocus.NULL.equals(newSelection)) {
            LOG.trace("Changing selection to {}", (Object)newSelection);
            this.getSelectionModel().selectIndices(newSelection.row(), newSelection.getRows());
            this.getFocusModel().focus(newSelection.getFocus());
            this.scrollTo(Math.max(newSelection.row() - 1, 0));
        }
    }

    @EventListener
    public void onSetPageRanges(SetPageRangesRequest event) {
        this.getItems().forEach(i -> i.pageSelection.set(event.range()));
    }

    @EventListener
    public void showPasswordFieldPopup(ShowPasswordFieldPopupRequest request) {
        Window owner;
        Scene scene = this.getScene();
        if (scene != null && (owner = scene.getWindow()) != null && owner.isShowing()) {
            Point2D nodeCoord = request.requestingNode().localToScene(request.requestingNode().getWidth() / 2.0, request.requestingNode().getHeight() / 1.5);
            double anchorX = Math.round(owner.getX() + scene.getX() + nodeCoord.getX() + 2.0);
            double anchorY = Math.round(owner.getY() + scene.getY() + nodeCoord.getY() + 2.0);
            this.passwordPopup.showFor((Node)this, request.pdfDescriptor(), anchorX, anchorY);
        }
    }

    private void copySelectedToClipboard() {
        ClipboardContent content = new ClipboardContent();
        ObjectCollectionWriter.writeContent((Collection)this.getSelectionModel().getSelectedItems().stream().map(item -> item.descriptor().getFile().getAbsolutePath() + ", " + item.descriptor().getFile().length() + ", " + String.valueOf(item.descriptor().pages().getValue())).collect(Collectors.toList())).to(content);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString((String)this.getId()) + "input.size", Integer.toString(this.getItems().size()));
        IntStream.range(0, this.getItems().size()).forEach(i -> {
            SelectionTableRowData current = (SelectionTableRowData)this.getItems().get(i);
            String id = StringUtils.defaultString((String)this.getId());
            data.put(id + "input." + i, current.descriptor().getFile().getAbsolutePath());
            if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SAVE_PWD_IN_WORKSPACE)) {
                data.put(id + "input.password.enc" + i, EncryptionUtils.encrypt((String)current.descriptor().getPassword()));
            }
            data.put(id + "input.range." + i, StringUtils.defaultString((String)current.pageSelection.get()));
            data.put(id + "input.step." + i, StringUtils.defaultString((String)current.pace.get()));
            data.put(id + "input.reverse." + i, Boolean.toString(current.reverse.get()));
        });
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.onClear(null);
        int size = Optional.ofNullable(data.get(StringUtils.defaultString((String)this.getId()) + "input.size")).map(Integer::valueOf).orElse(0);
        if (size > 0) {
            PdfLoadRequest loadEvent = new PdfLoadRequest(this.toolBinding());
            ArrayList items = new ArrayList();
            IntStream.range(0, size).forEach(i -> {
                String id = StringUtils.defaultString((String)this.getId());
                Optional.ofNullable((String)data.get(id + "input." + i)).ifPresent(f -> {
                    PdfDocumentDescriptor descriptor = PdfDocumentDescriptor.newDescriptor((File)new File((String)f), (String)Optional.ofNullable((String)data.get(id + "input.password.enc" + i)).map(EncryptionUtils::decrypt).orElseGet(() -> (String)data.get(StringUtils.defaultString((String)this.getId()) + "input.password." + i)));
                    loadEvent.add(descriptor);
                    SelectionTableRowData row = new SelectionTableRowData(descriptor);
                    row.pageSelection.set((String)data.get(id + "input.range." + i));
                    row.pace.set((String)data.get(id + "input.step." + i));
                    row.reverse.set(Boolean.parseBoolean((String)data.get(id + "input.reverse." + i)));
                    items.add(row);
                });
            });
            this.getItems().addAll(items);
            StaticStudio.eventStudio().broadcast((Object)loadEvent);
        }
    }

    public IntegerProperty getHoverIndex() {
        return this.hoverIndex;
    }

    private void dragScroll() {
        ScrollBar scrollBar = this.getVerticalScrollbar();
        if (scrollBar != null) {
            double newValue = scrollBar.getValue() + this.scrollDirection;
            newValue = Math.min(newValue, 1.0);
            newValue = Math.max(newValue, 0.0);
            scrollBar.setValue(newValue);
        }
    }

    private ScrollBar getVerticalScrollbar() {
        ScrollBar verticalScrollBar = null;
        for (Node node : this.lookupAll(".scroll-bar")) {
            ScrollBar bar;
            if (!(node instanceof ScrollBar) || !(bar = (ScrollBar)node).getOrientation().equals((Object)Orientation.VERTICAL)) continue;
            verticalScrollBar = bar;
        }
        return verticalScrollBar;
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        double proximity;
        Object hotRegion = (Region)this.lookup(".clipped-container");
        if (hotRegion.getBoundsInLocal().getWidth() < 1.0 && (hotRegion = this).getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded(evt);
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - hotRegion.localToScene(0.0, 0.0).getY();
        if (delta < (proximity = 50.0)) {
            yOffset = -(proximity - delta);
        }
        if ((delta = hotRegion.localToScene(0.0, 0.0).getY() + hotRegion.getHeight() - evt.getSceneY()) < proximity) {
            yOffset = proximity - delta;
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded(evt);
        }
    }

    private void stopAutoScrollIfNeeded(DragEvent evt) {
        this.scrollTimeline.stop();
    }

    private void autoscroll(double yOffset) {
        this.scrollDirection = yOffset > 0.0 ? 1.0 / (double)this.getItems().size() : -1.0 / (double)this.getItems().size();
        this.scrollTimeline.play();
    }
}

