/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.util.Comparator;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.components.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.components.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.components.selection.multiple.TooltippedTableCell;

public class SelectedPagesColumn
implements SelectionTableColumn<Integer> {
    @Override
    public String getColumnTitle() {
        return I18nContext.i18n().tr("Selected pages");
    }

    @Override
    public ObservableValue<Integer> getObservableValue(SelectionTableRowData data) {
        return data.selectedPages.asObject();
    }

    @Override
    public String getTextValue(Integer item) {
        if (Objects.nonNull(item) && item >= 0) {
            return item.toString();
        }
        return "";
    }

    @Override
    public Float prefWidth() {
        return Float.valueOf(50.0f);
    }

    @Override
    public Comparator<Integer> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public Callback<TableColumn<SelectionTableRowData, Integer>, TableCell<SelectionTableRowData, Integer>> cellFactory() {
        return param -> new TooltippedTableCell<Integer>(I18nContext.i18n().tr("Total number of selected pages")){

            @Override
            void onUpdateItem(Integer item, boolean empty) {
                if (empty || item == null) {
                    this.setText("");
                } else {
                    this.setText(SelectedPagesColumn.this.getTextValue(item));
                }
            }
        };
    }
}

