/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;
import org.kordamp.ikonli.javafx.FontIcon;
import org.pdfsam.model.pdf.PdfDescriptorLoadingStatus;
import org.sejda.commons.util.RequireUtils;
import org.sejda.commons.util.StringUtils;

public class LoadingStatusIndicatorUpdater
implements Consumer<PdfDescriptorLoadingStatus> {
    private final Labeled indicator;

    public LoadingStatusIndicatorUpdater(Labeled indicator) {
        RequireUtils.requireNotNullArg((Object)indicator, (String)"Cannot set loading status on a null indicator");
        this.indicator = indicator;
    }

    @Override
    public void accept(PdfDescriptorLoadingStatus t) {
        FontIcon icon = Optional.ofNullable(t).map(PdfDescriptorLoadingStatus::getIcon).map(FontIcon::of).orElse(null);
        if (Objects.nonNull(icon)) {
            this.indicator.setGraphic((Node)icon);
            this.indicator.setContentDisplay(ContentDisplay.CENTER);
        } else {
            this.indicator.setGraphic(null);
        }
        Arrays.stream(PdfDescriptorLoadingStatus.values()).map(PdfDescriptorLoadingStatus::getStyle).filter(StringUtils::isNotEmpty).forEach(arg_0 -> this.indicator.getStyleClass().remove(arg_0));
        if (Objects.nonNull(t) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t.getStyle())) {
            this.indicator.getStyleClass().add((Object)t.getStyle());
        }
        if (Objects.nonNull(t) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t.getDescription())) {
            this.indicator.setTooltip(new Tooltip(t.getDescription()));
        } else {
            this.indicator.setTooltip(null);
        }
    }
}

