/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.sejda.model.pdf.PdfVersion;

class PdfVersionFilter {
    private final SortedSet<PdfVersion> filters = new TreeSet<PdfVersion>(Comparator.comparingDouble(PdfVersion::getVersion));
    private final ReadOnlyObjectWrapper<PdfVersion> required = new ReadOnlyObjectWrapper();

    PdfVersionFilter() {
        this.addFilter(PdfVersion.VERSION_1_0);
    }

    public void addFilter(PdfVersion version) {
        this.filters.add(version);
        this.required.set((Object)this.filters.last());
    }

    public void removeFilter(PdfVersion version) {
        this.filters.remove(version);
        this.required.set((Object)this.filters.last());
    }

    void reset() {
        this.filters.clear();
        this.addFilter(PdfVersion.VERSION_1_0);
    }

    ReadOnlyObjectProperty<PdfVersion> requiredProperty() {
        return this.required.getReadOnlyProperty();
    }
}

