/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.PersistentProperty;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.AddPdfVersionConstraintEvent;
import org.pdfsam.model.ui.ChangedSelectedPdfVersionEvent;
import org.pdfsam.model.ui.DefaultPdfVersionComboItem;
import org.pdfsam.model.ui.PdfVersionComboItem;
import org.pdfsam.model.ui.RemovePdfVersionConstraintEvent;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.ui.components.io.PdfVersionFilter;
import org.sejda.model.pdf.PdfVersion;

class PdfVersionCombo
extends ComboBox<PdfVersionComboItem>
implements ToolBound,
ResettableView {
    private final String toolBinding;
    private final ObservableList<PdfVersionComboItem> unfilteredItems = FXCollections.observableArrayList();
    private final PdfVersionFilter versionsFilter = new PdfVersionFilter();
    private final SameAsSourceComboItem sameAsSource = new SameAsSourceComboItem();

    public PdfVersionCombo(String toolBinding) {
        this.toolBinding = toolBinding;
        Arrays.stream(PdfVersion.values()).filter(v -> v.getVersion() > PdfVersion.VERSION_1_2.getVersion()).map(DefaultPdfVersionComboItem::new).forEach(arg_0 -> this.unfilteredItems.add(arg_0));
        this.versionsFilter.requiredProperty().addListener((observable, oldVal, newVal) -> this.setFilteredItems((PdfVersion)newVal));
        this.resetView();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void setFilteredItems(PdfVersion required) {
        if (Objects.nonNull(required)) {
            PdfVersionComboItem selected = (PdfVersionComboItem)this.getSelectionModel().getSelectedItem();
            this.setItems((ObservableList)this.unfilteredItems.filtered(t -> t.isHigherOrEqual(required)));
            int selectedIndex = this.getItems().indexOf((Object)selected);
            if (selectedIndex != -1) {
                this.getSelectionModel().select(selectedIndex);
            } else {
                this.getSelectionModel().selectFirst();
            }
        }
    }

    @EventListener
    public void onAddPdfVersionConstraint(AddPdfVersionConstraintEvent event) {
        this.versionsFilter.addFilter(event.pdfVersion());
    }

    @EventListener
    public void onRemovePdfVersionConstraint(RemovePdfVersionConstraintEvent event) {
        this.versionsFilter.removeFilter(event.pdfVersion());
    }

    @EventListener
    public void onChangedSelectedPdfVersion(ChangedSelectedPdfVersionEvent event) {
        this.sameAsSource.setVersion(event.pdfVersion());
        this.setFilteredItems((PdfVersion)this.versionsFilter.requiredProperty().get());
    }

    @EventStation
    public String toolBinding() {
        return this.toolBinding;
    }

    public void resetView() {
        this.versionsFilter.reset();
        this.versionsFilter.addFilter(PdfVersion.VERSION_1_2);
        ApplicationContext.app().persistentSettings().get(StringPersistentProperty.PDF_VERSION).map(PdfVersion::valueOf).flatMap(v -> this.getItems().stream().filter(i -> i.getVersion() == v).findFirst()).ifPresent(i -> this.getSelectionModel().select(i));
    }

    public void enableSameAsSourceItem() {
        this.unfilteredItems.add(0, (Object)this.sameAsSource);
        if (!ApplicationContext.app().persistentSettings().hasValueFor((PersistentProperty)StringPersistentProperty.PDF_VERSION)) {
            this.getSelectionModel().selectFirst();
        }
    }

    private static class SameAsSourceComboItem
    implements PdfVersionComboItem {
        private PdfVersion version = PdfVersion.VERSION_1_5;

        private SameAsSourceComboItem() {
        }

        void setVersion(PdfVersion version) {
            this.version = Optional.ofNullable(version).orElse(PdfVersion.VERSION_1_5);
        }

        public PdfVersion getVersion() {
            return this.version;
        }

        public boolean isHigherOrEqual(PdfVersion other) {
            return this.version.getVersion() >= other.getVersion();
        }

        public String toString() {
            return I18nContext.i18n().tr("Same as the input document");
        }
    }
}

