/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.util.function.Consumer;
import org.pdfsam.core.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.io.OpenType;
import org.pdfsam.ui.components.io.BrowsableFileField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.sejda.conversion.PdfFileSourceAdapter;

public class BrowsablePdfInputField
extends BrowsableFileField
implements TaskParametersBuildStep<SinglePdfSourceTaskParametersBuilder<?>> {
    public BrowsablePdfInputField() {
        super(FileType.PDF, OpenType.OPEN);
    }

    public void apply(SinglePdfSourceTaskParametersBuilder<?> builder, Consumer<String> onError) {
        this.getTextField().validate();
        if (this.getTextField().getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.source(new PdfFileSourceAdapter(this.getTextField().getText()).getPdfFileSource());
        } else {
            onError.accept(I18nContext.i18n().tr("The selected PDF file is invalid"));
        }
    }
}

