/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.core.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.NonExistingOutputDirectoryEvent;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.io.BrowsableDirectoryField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.SingleOrMultipleTaskOutput;
import org.sejda.model.parameter.base.SingleOrMultipleOutputTaskParameters;

public class BrowsableOutputDirectoryField
extends BrowsableDirectoryField
implements TaskParametersBuildStep<MultipleOutputTaskParametersBuilder<?>> {
    public BrowsableOutputDirectoryField() {
        this(ApplicationContext.app());
    }

    BrowsableOutputDirectoryField(ApplicationContext context) {
        context.persistentSettings().get(StringPersistentProperty.WORKING_PATH).ifPresent(arg_0 -> ((ValidableTextField)this.getTextField()).setText(arg_0));
        this.getTextField().setValidator((Validator<String>)Validators.and((Validator[])new Validator[]{Validators.nonBlank(), v -> !Files.isRegularFile(Paths.get(v, new String[0]), new LinkOption[0])}));
    }

    public void apply(MultipleOutputTaskParametersBuilder<? extends SingleOrMultipleOutputTaskParameters> builder, Consumer<String> onError) {
        this.getTextField().validate();
        if (this.getTextField().getValidationState() == FXValidationSupport.ValidationState.VALID) {
            Path output = Paths.get(this.getTextField().getText(), new String[0]);
            if (!Files.exists(output, new LinkOption[0])) {
                StaticStudio.eventStudio().broadcast((Object)new NonExistingOutputDirectoryEvent(output));
            }
            if (Files.isDirectory(output, new LinkOption[0])) {
                builder.output((SingleOrMultipleTaskOutput)FileOrDirectoryTaskOutput.directory((File)output.toFile()));
            } else {
                onError.accept(I18nContext.i18n().tr("An existing output directory is required"));
            }
        } else {
            onError.accept(I18nContext.i18n().tr("The output directory is required"));
        }
    }
}

