/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.commons;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.model.io.NativeOpenUrlRequest;
import org.pdfsam.ui.components.support.Style;
import org.sejda.commons.util.RequireUtils;

public class UrlButton
extends Button {
    private UrlButton(String text) {
        super(text);
    }

    public static final UrlButton styledUrlButton(String text, String url, Ikon icon) {
        return UrlButton.urlButton(text, url, icon, Style.BUTTON.css());
    }

    public static UrlButton urlButton(String text, String url, Ikon icon, String ... style) {
        RequireUtils.requireNotBlank((String)url, (String)"URL cannot be blank");
        UrlButton button = new UrlButton(text);
        button.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new NativeOpenUrlRequest(url)));
        if (Objects.nonNull(icon)) {
            button.setGraphic((Node)FontIcon.of((Ikon)icon));
        }
        if (Objects.nonNull(style) && style.length > 0) {
            button.getStyleClass().addAll((Object[])style);
        }
        return button;
    }
}

