/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.commons;

import java.util.Objects;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import org.pdfsam.ui.components.support.Style;
import org.sejda.commons.util.RequireUtils;

public class RadioButtonDrivenTextFieldsPane
extends GridPane {
    private int rows = 0;
    private final ToggleGroup group;

    public RadioButtonDrivenTextFieldsPane(ToggleGroup group) {
        this.group = group;
        this.getStyleClass().addAll((Object[])Style.GRID.css());
    }

    public void addRow(RadioButton radio, Region field, Text helpIcon) {
        RequireUtils.requireNotNullArg((Object)radio, (String)"Cannot add a null radio");
        RequireUtils.requireNotNullArg((Object)field, (String)"Cannot add a null field");
        GridPane.setValignment((Node)radio, (VPos)VPos.BOTTOM);
        GridPane.setValignment((Node)field, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)radio, (HPos)HPos.LEFT);
        GridPane.setHalignment((Node)field, (HPos)HPos.LEFT);
        GridPane.setFillWidth((Node)field, (Boolean)true);
        field.setPrefWidth(300.0);
        field.setDisable(true);
        radio.selectedProperty().addListener((o, oldVal, newVal) -> {
            field.setDisable(newVal == false);
            if (newVal.booleanValue()) {
                field.requestFocus();
            }
        });
        radio.setToggleGroup(this.group);
        this.add((Node)radio, 0, this.rows);
        this.add((Node)field, 1, this.rows);
        if (Objects.nonNull(helpIcon)) {
            this.add((Node)helpIcon, 2, this.rows);
        }
        ++this.rows;
    }
}

