/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.backpages;

import java.util.Objects;
import java.util.Set;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.SinglePdfSourceTaskParametersBuilder;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfSource;
import org.sejda.model.output.SingleOrMultipleTaskOutput;
import org.sejda.model.parameter.AddBackPagesParameters;
import org.sejda.model.pdf.page.PageRange;

class AddBackpagesParametersBuilder
extends AbstractPdfOutputParametersBuilder<AddBackPagesParameters>
implements SinglePdfSourceTaskParametersBuilder<AddBackPagesParameters> {
    private PdfFileSource source;
    private SingleOrMultipleTaskOutput output;
    private PdfFileSource backPagesSource;
    private int step = 1;
    private Set<PageRange> ranges;

    AddBackpagesParametersBuilder() {
    }

    public void source(PdfFileSource source) {
        this.source = source;
    }

    public void backPagesSource(PdfFileSource backPagesSource) {
        this.backPagesSource = backPagesSource;
    }

    public void output(SingleOrMultipleTaskOutput output) {
        this.output = output;
    }

    public void step(int step) {
        this.step = step;
    }

    public void ranges(Set<PageRange> ranges) {
        this.ranges = ranges;
    }

    public AddBackPagesParameters build() {
        AddBackPagesParameters params = new AddBackPagesParameters();
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        params.setOutput(this.output);
        params.setBackPagesSource((PdfSource)this.backPagesSource);
        params.setStep(this.step);
        params.addSource((PdfSource)this.source);
        if (Objects.nonNull(this.ranges)) {
            params.addAllPageRanges(this.ranges);
        }
        return params;
    }
}

